#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Panelled TubeMod01.fsh   by  Shane  
//https://www.shadertoy.com/view/MlKXz3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*

	Panelled Tube
	-------------

	Nothing exciting. Just a less detailed, slightly cleaner rehash of my previous tunnel
	example. I was going for a hard-lacquered faux timber panel look, because I wanted 
	something reflective and shiny, but it's possible to make it look like real timber with 
	a few setting and material changes here and there.

	I'm on a very fast laptop at the moment, so I have no idea how well - or badly - this 
	runs. My mother used to say that the best optimizing tool is a slow computer. I tend to 
	agree, but sometimes it can be disappointing getting something looking the way you want 
	on your good machine, then having to throw out details in order to cater for older 
	hardware... OK, reading that sentence back to myself brings the "First World Problems" 
	meme to mind. :D	

	Anyway, without the cheap (12 iteration) reflective pass, I'd imagine this would run 
	at 60 fps on most systems. With it... between 30 and 60 fps, although that's just a 
	guess.
	

*/

// Maximum ray distance.
#define FAR 50.

// Coyote's snippet to provide a virtual reality element. Really freaky. It gives the scene 
// physical depth, but you have to do that magic picture focus adjusting thing with your eyes.
//#define THREE_D 

// Object ID, used for the gold trimming in the bump mapping section.
float svObjID, svObjID2;
vec3 vObjID;

#define TUN 0. // Tunnel: Basically, the metal plates.
#define ROD 1. // Rod:  Silver rod, and washer, attached to the bolts.
#define BLT 2. // Bolts:  The hexagonal fasteners.

// 2D rotation. Always handy. Angle vector, courtesy of Fabrice.
mat2 rot( float th ){ vec2 a = sin(vec2(1.5707963, 0) + th); return mat2(a, -a.y, a.x); }


// Camera path. Arranged to coincide with the frequency of the lattice.
vec3 camPath(float t){
  
    //return vec3(0, 0, t); // Straight path.
    
    // Curvy path. Weaving around the columns.
    float a = sin(t*3.14159265/16. + 1.5707963);
    float b = cos(t*3.14159265/16.);
    
    return vec3(a, b*a*.5, t);     
}

// Camera path. Arranged to coincide with the frequency of the lattice.
vec3 camPathPL(float t){
  
    //return vec3(0, 0, t); // Straight path.
    
    float it = floor(t + 1.);
    float ft = t - it;
    
    // Curvy path. Weaving around the columns.
    float a = sin(it*3.14159265/16. + 1.5707963);
    float b = cos(it*3.14159265/16.);
    
    vec2 p0 = vec2(a, b*a*.5);
    
    a = sin((it + 1.)*3.14159265/16. + 1.5707963);
    b = cos((it + 1.)*3.14159265/16.);
    
    vec2 p1 = vec2(a, b*a*.5);
    
    vec2 p = mix(p0, p1, ft);
    
    return vec3(p, t);     
}


// Minimum - with corresponding object ID.
vec2 objMin(vec2 a, vec2 b){ 
    
    // Returning the minimum distance along with the ID of the
    // object. This is one way to do it. There are others.
    return a.x < b.x ? a : b;
    
    //Equivalent to: return a.x < b.x ? a: b; 
    //float s = step(a.x, b.x);
    //return s*a + (1. - s)*b;
}


// The tunnel scene. There's a bit of code, but it's nothing more than a bunch of boxes
// and cylinders spread out around some repeat cylindrical coordinates.
float map(vec3 p){
    
    const float depth = .25; // Depth of the rounded metal plates.
    
    // Mold the scene around the path.
    p.xy -= camPath(p.z).xy;
    
    // The edge of the tunnel. Set at a radius of one, plus the depth.
    float tun = (1. + depth) - length(p.xy); 
    //max(abs(p.x)*.866025 + abs(p.y)*.5, abs(p.y));//

    
    ///////////////
    
    // The tunnel walls. Due to the amount of detailing and the polar conversion, it 
    // looks more complicated than it actually is. To repeat across the XY plane we
    // do something along the lines of "p.xz = mod(p.xz, c) - c/2." To repeat around
    // a circle in the XY plane, we convert to polar coordinates, "p.xy = rot(angle),"
    // (angle is based on "atan(p.y, p.x)," then do the same thing. The rest is basic
    // unit circle trigonometry, etc. By the way, this is a rough description, so if
    // something doesn't quite make sense, it probably doesn't. :)
    
    // Converting the XY plane to polar coordinates. I'm handling the panels (five per
    // circle) and the bolts (15 per circle) at the same time to share some calculations.
    // I'd love to use the geometry of one to constuct the other - in order to save
    // some instructions, but I'm leaving it alone for now.
    vec3 q = p; 
    vec3 q2 = p;    
    
    float a = atan(q.y, q.x)/6.2831853; // Polar angle of "p.xy" coordinate.
    float ia = (floor(a*5.) + .5)/5.*6.2831853; // Angle between "PI/5" intervals.
    float ia2 = (floor(a*15.) + .5)/15.*6.2831853; // Angle between "PI/15" intervals.
    
     // Polar conversion for 5 segments, but offset every second panel.
    q.xy *= rot(ia + sign(mod(q.z + 1., 4.) - 2.)*3.14159/15.);// 
    //float of2 = sign(mod(q.z + .5, 2.) - 1.)*3.14159/15.;
    q2.xy *= rot(ia2); // Polar conversion for 15 segments (for the bolts).
   
    // The X-coordinate is now the radial coordinate, which radiates from the center
    // to infinity. We want to break it into cells that are 2 units wide, but centered
    // in the middle. The result is that the panels will start at radius one.
    q.x = mod(q.x, 2.) - 1.;
    // Plain old linear Z repetion. We want the panels and bolts to be repeated in the
    // Z-direction (down the tunnel) every half unit.
    q.z = mod(q.z, 2.) - 1.;
    
    // Moving the bolts out to a distance of 2.25.
    q2.x = mod(q2.x, (2. + .25)) - (2. + .25)/2.;
    
    // Now, it's just a case of drawing and positioning some basic shapes. Boxes and
    // tubes with a hexagonal cross-section.
    q = abs(q);
    q2 = abs(q2);

    // Panelling details.
    float tunDetail = max(min(q.y, q.z) - .07, -(min(q.y, q.z) - .007));     
 
    // Adding the tunnel details (with a circular center taken out) to the tunnel.
    tun = min(tun, max(tunDetail, tun-depth));  
    
    ///////////////
    
    // Bolts: Hexagon shapes spaced out fifteen times around the tunnel walls. The 
    // panels are spaced out in fifths, so that means three per panel. And yes, they're
    // technically nuts (not bolts), but I was too lazy to change the variable names
    // for the previous example. :)
    float blt = max(max(q2.x*.866025 + q2.y*.5, q2.y) - .055, q.z - .16);
    //blt = min(blt, max(length(q2.xy) - .07, q.z - .08));
    
    float thread = max(sin(q.z*6.283*64.)*2., 0.)*.002;
    float rod = max(length(q2.xy) - .025 + thread, q.z - .19);
    rod = min(rod, max(length(q2.xy) - .075, q.z - .09));


    
    // Determine the overall closest object and its corresponding object ID. There's a way
    // to save some cycles and take the object-ID calculations out of the distance function, 
    // but I'm leaving them here for simplicity.
    //vec2 d = objMin(vec2(tun, TUN), vec2(blt, BLT));
    //d = objMin(d, vec2(rod, ROD));
    
    // Save all the object IDs here, then sort them later. It's overcomplicated, but saves 
    // a few cycles.
    vObjID = vec3(tun, blt, rod);
    
    return min(min(tun, blt), rod); // Return the closest distance.


    
    
}


// The reflections are pretty subtle, so not much effort is being put into them. Only a few iterations.
// For faster machines, use about 32 iterations, and you'll get a more accurate reflection.
float refTrace(vec3 ro, vec3 rd){

    float t = 0.0;
    for(int i=0; i<12; i++){
        float d = map(ro + rd*t);
        if (abs(d) < 0.005*(t*.25 + 1.) || t>FAR) break;
        t += d;
    } 
    return t;
}


// Raymarching.
float trace(vec3 ro, vec3 rd){

    float t = 0., d;
    for (int i=0; i<96; i++){

        d = map(ro + rd*t);
        if(abs(d)<.001*(t*.125 + 1.) || t>FAR) break;
        t += d;
    }
    return min(t, FAR);
}

// Tri-Planar blending function. Based on an old Nvidia writeup:
// GPU Gems 3 - Ryan Geiss: http://http.developer.nvidia.com/GPUGems3/gpugems3_ch01.html
vec3 tex3D(sampler2D texture0, vec3 p, vec3 n){
    
    // Adjusting the texture calculations to the camera path. Add in the checkered texture,
    // then comment it out to see what it's for.
    p.xy -= camPath(p.z).xy;
    
    n = max(abs(n) - .2, 0.001);
    n /= dot(n, vec3(1));
	vec3 tx = texture2D(texture0, p.yz).xyz;
    vec3 ty = texture2D(texture0, p.xz).xyz;
    vec3 tz = texture2D(texture0, p.xy).xyz;
    
    // Textures are stored in sRGB (I think), so you have to convert them to linear space 
    // (squaring is a rough approximation) prior to working with them... or something like that. :)
    // Once the final color value is gamma corrected, you should see correct looking colors.
    return tx*tx*n.x + ty*ty*n.y + tz*tz*n.z;
}



/*
// The normal function with some 6-tap curvature rolled into it. Sometimes, it's possible to get away
// with six taps overall, but we need a bit of epsilon value variance here, so there's an extra six.
vec3 nr(vec3 p, inout float crv, float ef){ 
	//ef/iResolution.y
    vec2 e = vec2(ef/450., 0); // Larger epsilon for greater sample spread, thus thicker edges.

    // Take some distance function measurements from either side of the hit point on all three axes.
	float d1 = map(p + e.xyy), d2 = map(p - e.xyy);
	float d3 = map(p + e.yxy), d4 = map(p - e.yxy);
	float d5 = map(p + e.yyx), d6 = map(p - e.yyx);
	float d = map(p);	// The hit point itself - Doubled to cut down on calculations. See below.
    
    // Seven-tap curvature calculation. You can get away with four taps, but this is a little
    // more accurate.
    crv = clamp((d1 + d2 + d3 + d4 + d5 + d6 - d*6.)*32. + .5, 0., 1.);
	
    // Redoing the calculations for the normal with a more precise epsilon value.
    e = vec2(.005, 0);
	d1 = map(p + e.xyy), d2 = map(p - e.xyy);
	d3 = map(p + e.yxy), d4 = map(p - e.yxy);
	d5 = map(p + e.yyx), d6 = map(p - e.yyx); 
    
    // Return the normal.
    // Standard, normalized gradient mearsurement.
    return normalize(vec3(d1 - d2, d3 - d4, d5 - d6));
}
*/


// The normal function with some cheaper 4-tap curvature rolled into it. The 4-tap curvature
// came from Nimitz.
vec3 nrHyb(vec3 p, inout float crv, float ef){ 
	
    // Edging thickness. I wanted the edges to be resolution independent... or to put it
    // another way, I wanted the lines to be a certain pixel width regardless of the 
    // canvas size. If you don't, then the lines can look too fat in fullscreen.
    vec2 e = vec2(-1., 1.)*.66*ef/450.;  
    
    // The hit point value, and four nearby samples, spaced out in a tetrahedral fashion.
	float d1 = map(p + e.yxx), d2 = map(p + e.xxy);
	float d3 = map(p + e.xyx), d4 = map(p + e.yyy);
    float d = map(p);
    float d5, d6;
    
    crv = clamp((d1 + d2 + d3 + d4 - d*4.)*24. + .5, 0., 1.);
	
    // Redoing the calculations for the normal with a more precise epsilon value.
    e = vec2(.005, 0);
	d1 = map(p + e.xyy), d2 = map(p - e.xyy);
	d3 = map(p + e.yxy), d4 = map(p - e.yxy);
	d5 = map(p + e.yyx), d6 = map(p - e.yyx); 
    
    // Return the normal.
    // Standard, normalized gradient mearsurement.
    return normalize(vec3(d1 - d2, d3 - d4, d5 - d6));
}


// Tetrahedral normal - courtesy of IQ. I'm in saving mode, so am saving a few map calls.
// I've added to the function to include a rough tetrahedral edge calculation.
vec3 nrRef(in vec3 p, inout float crv, in float ef){
  
    // Edging thickness. I wanted the edges to be resolution independent... or to put it
    // another way, I wanted the lines to be a certain pixel width regardless of the 
    // canvas size. If you don't, then the lines can look too fat in fullscreen.
    vec2 e = vec2(-1., 1.)*.66*ef/450.;  
    
    // The hit point value, and four nearby samples, spaced out in a tetrahedral fashion.
	float d1 = map(p + e.yxx), d2 = map(p + e.xxy);
	float d3 = map(p + e.xyx), d4 = map(p + e.yyy); 
    float d = map(p);
    
    // Edge calculation. Taking for samples around the hit point and determining how
    // much they vary. Large variances tend to indicate an edge.
    //crv = abs(d1 + d2 + d3 + d4 - d*4.);
    //crv = smoothstep(0., 1., sqrt(crv/e.y*2.));
    
    crv = clamp((d1 + d2 + d3 + d4 - d*4.)*24. + .5, 0., 1.);
    
    // Recalculating for the normal. I didn't want the sample spacing to change from
    // one resolution to the next. Hence, the fixed number. Just for the record, I tend
    // to work within the 800 by 450 window. 
    e = vec2(-1., 1.)*.002;  
	d1 = map(p + e.yxx), d2 = map(p + e.xxy);
	d3 = map(p + e.xyx), d4 = map(p + e.yyy); 
    
    // Normalizing.
	return normalize(e.yxx*d1 + e.xxy*d2 + e.xyx*d3 + e.yyy*d4 );   
}


// I keep a collection of occlusion routines... OK, that sounded really nerdy. :)
// Anyway, I like this one. I'm assuming it's based on IQ's original.
float cao(in vec3 p, in vec3 n){
	
    float sca = 1., occ = 0.;
    for(float i=0.; i<5.; i++){
    
        float hr = .01 + i*.5/4.;        
        float dd = map(n * hr + p);
        occ += (hr - dd)*sca;
        sca *= 0.7;
    }
    return clamp(1.0 - occ, 0., 1.);    
}


// Cheap shadows are hard. In fact, I'd almost say, shadowing particular scenes with limited 
// iterations is impossible... However, I'd be very grateful if someone could prove me wrong. :)
float softShadow(vec3 ro, vec3 lp, float k){

    // More would be nicer. More is always nicer, but not really affordable... Not on my slow test machine, anyway.
    const int maxIterationsShad = 20; 
    
    vec3 rd = (lp-ro); // Unnormalized direction ray.

    float shade = 1.0;
    float dist = 0.05;    
    float end = max(length(rd), 0.001);
    //float stepDist = end/float(maxIterationsShad);
    
    rd /= end;

    // Max shadow iterations - More iterations make nicer shadows, but slow things down. Obviously, the lowest 
    // number to give a decent shadow is the best one to choose. 
    for (int i=0; i<maxIterationsShad; i++){

        float h = map(ro + rd*dist);
        shade = min(shade, k*h/dist);
        //shade = min(shade, smoothstep(0.0, 1.0, k*h/dist)); // Subtle difference. Thanks to IQ for this tidbit.
        //dist += min( h, stepDist ); // So many options here: dist += clamp( h, 0.0005, 0.2 ), etc.
        dist += clamp(h, 0.01, 0.25);
        
        // Early exits from accumulative distance function calls tend to be a good thing.
        if (h<0.001 || dist > end) break; 
    }

    // I've added 0.5 to the final shade value, which lightens the shadow a bit. It's a preference thing.
    return min(max(shade, 0.) + 0.2, 1.0); 
}

/*
// Simple environment mapping. Pass the reflected vector in and create some
// colored noise with it. The normal is redundant here, but it can be used
// to pass into a 3D texture mapping function to produce some interesting
// environmental reflections.
vec3 eMap(vec3 rd, vec3 sn){
    
    vec3 tx = tex3D(iChannel0, rd, sn);
    return tx*.5 + smoothstep(0.02, .8, tx);
}
*/


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

    // Screen coordinates.
	vec2 u = (fragCoord - iResolution.xy*0.5)/iResolution.y;
    
    #ifdef THREE_D
    float sg = sign(fragCoord.x - .5*iResolution.x);
    u.x -= sg*.25*iResolution.x/iResolution.y;
    #endif
	
	// Camera Setup.
    float speed = 2.;
    vec3 ro = camPath(iTime*speed + .0); // Camera position, doubling as the ray origin.
    
    vec3 lk = camPath(iTime*speed + .5);  // "Look At" position.
    //ro.y -= .1; // Hack to lower the camera.
    //lk.y -= .1;
    
    vec3 lp = camPath(iTime*speed + 2.); // Light position, somewhere near the moving camera.
    lp.y += .5;
    // Alternative. Moving the light to the right a bit. 
    //float th = 6.283*1./12.;
    //lp += vec3(sin(th)*.6, cos(th)*.6, 0); 
    
    #ifdef THREE_D
    ro.x -= sg*.15; lk.x -= sg*.15; lp.x -= sg*.15;
    #endif
    

    // Using the above to produce the unit ray-direction vector.
    float FOV = .75; // FOV - Field of view.
    vec3 fwd = normalize(lk-ro);
    vec3 rgt = normalize(vec3(fwd.z, 0., -fwd.x )); 
    vec3 up = cross(fwd, rgt);

    // Unit direction ray.
    //vec3 rd = normalize(fwd + FOV*(u.x*rgt + u.y*up));
    
    // Mild lens distortion to fit more of the scene in, and to mix things up a little.
    vec3 rd = fwd + FOV*(u.x*rgt + u.y*up);
    rd = normalize(vec3(rd.xy, (rd.z - length(rd.xy)*.25)*.75));
    
    // Swiveling the camera from left to right when turning corners.
    float swivel = camPath(lk.z).x;
    rd.xy = rot(swivel/48. )*rd.xy;
    rd.xz = rot(swivel/32. )*rd.xz;
 
    
    // Raymarch.
    float t = trace(ro, rd);
    
    // Determine the object ID here. It's a more cumbersome method, but a saves a
    // heap of sorting in the distance function, so is a lot faster.
    vec2 vObj = objMin(vec2(vObjID.x, TUN), vec2(vObjID.y, BLT));
    vObj = objMin(vObj, vec2(vObjID.z, ROD));
    svObjID = vObj.y;
    
    // Surface hit point.
    vec3 sp = ro + rd*t;
    
    // Offset path. It's handy to have an adjusted hit point 
    // that aligns with the path contour.
    //vec3 pathSp = sp - camPath(sp.z);
    
    
    // Normal with curvature component.
    float crv = 1., ef = 8.; // ef - Edge and curvature factor.
    
    // Normal and curvature calculations.
    vec3 sn = nrHyb(sp, crv, ef);
    
    //vec3 svN = sn; // Sometimes, it's handy to save the normal before bumpping it.
    
    // Shadows and ambient self shadowing.
    float sh = softShadow(sp, lp, 16.); // Soft shadows.
    float ao = cao(sp, sn); // Ambient occlusion.
    
    // Light direction vector setup and light to surface distance.
    vec3 ld = lp - sp;
    float lDist = max(length(ld), .0001);
    ld /= lDist;
    
    // Attenuation.
    float atten = 1./(1.0 + lDist*.25 + lDist*lDist*.025);
    
    // Texturing the object.
    const float tSize0 = 1./1.;
    vec3 tx = tex3D(texture0, sp*tSize0, sn);
    tx = tx*.5 + smoothstep(0.02, .8, tx)*1.;
 
    // Ugly "if" statements for object coloring. They do the job though. 
    float gr = dot(tx, vec3(.299, .587, .114));    
    if(svObjID==TUN) tx *= vec3(1); 
	else if(svObjID==ROD) tx = (gr*.5 + .5)*vec3(1);//vec3(1.25, 1, .75);
    else if(svObjID==BLT) tx = (tx*.5 + .5)*vec3(1.4, .7, .05);

 
    
    // Diffuse, specular and Fresnel.
    float dif = max(dot(ld, sn), 0.);
    
    float spe = pow(max(dot(reflect(rd, sn), ld), 0.), 64.);
    //float fre = pow(clamp(dot(rd, sn) + 1., 0., 1.), 2.);
    
    // The specular looks a little too full on at particular angles, so I've had to do
    // the Schlick thing to tone them down a little.
    float Schlick = pow( 1. - max(dot(rd, normalize(rd + ld)), 0.), 5.0);
    Schlick = mix(.5, 1., Schlick);
    
    // Ramp up the diffuse on the metallic objects.
    if(svObjID!=TUN)
        dif = (pow(dif, 4.)*.5 + pow(dif, 8.)*.5)*3.;

  
    /////////////////////
    // Cheap reflection: Not entirely accurate, but the reflections are pretty subtle, so not much 
    // effort is being put in. By the way, this is really ugly, and there are definitely neater
    // ways to get the job done.
    //
    vec3 ref = reflect(rd, sn); // Reflected ray. //svN*.1 + sn*.9
    float rt = refTrace(sp + ref*0.1, ref); // Raymarch from "sp" in the reflected direction.
    vObj = objMin(vec2(vObjID.x, TUN), vec2(vObjID.y, BLT));
    vObj = objMin(vObj, vec2(vObjID.z, ROD));
    svObjID2 = vObj.y;
    float crv2 = 1.;
    vec3 rsp = sp + ref*rt; // Reflected surface hit point.
    vec3 rsn = nrRef(rsp, crv2, ef); // Normal at the reflected surface. //, cr2, ef

    vec3 rCol = tex3D(texture0, rsp*tSize0, rsn);
    rCol = smoothstep(0.02, .8, rCol)*2.;

    gr = dot(rCol, vec3(.299, .587, .114)); 
    if(svObjID2==TUN) rCol *= vec3(1); 
    else if(svObjID2==ROD) rCol = (gr*.5 + .5)*vec3(1);
    else if(svObjID2==BLT) rCol = (rCol*.5 + .5)*vec3(1.4, .7, .05);

    float rDiff = max(dot(rsn, normalize(lp-rsp)), 0.); // Diffuse light at "rsp."
    float rSpec = pow(max(dot(reflect(ref, rsn), normalize(lp-rsp)), 0.), 8.); // Diffuse light at "rsp."
    float rlDist = length(lp - rsp);

    if(svObjID2!=TUN) rDiff = (pow(rDiff, 4.)*.5 + pow(rDiff, 8.)*.5)*3.;

    // Reflected color. Not entirely accurate, but close enough. 
    rCol = rCol*(rDiff + .25) + vec3(1., .6, .2)*rSpec*2.;
    rCol *= 1./(1. + rlDist*0.25 + rlDist*rlDist*.025); 
    rCol *= min(crv2*1.5, 1.);
    ///////////////////
    
     
    // Combining the terms above to produce the final color.
    // Note the ambient occlusion term in place of a constant ambient term. It makes for a subtle
    // difference in ambient lighting in the corners. It's fake, obviously. :)
    vec3 fc = tx*(dif + ao*.3) + vec3(1, .6, .2)*spe*Schlick*2.; // + vec3(1, .9, .7)*spot*4.
    
    
    if(svObjID != TUN) fc += rCol*.5;
    else fc += rCol*.25;
    

    
    // Very uninspiring, fake environment mapping.. but much cheaper than the raymarched
    // reflective pass above.
    //fc += (dif*dif + spe)*eMap(reflect(rd, sn)/1.5, sn)*.15;
    
    
       
    fc *= atten*sh*ao;
    //fc *= (1. - crv*.8);
    fc *= clamp(crv*1.5, 0., 1.);
    
  
    
    // Mixing in some fog.
    vec3 bg = vec3(1, .7, .4);
    fc = mix(fc, bg*2., smoothstep(0., .95, t/FAR));
    
     
    // Post processing.
    //float gr = dot(fc, vec3(.299, .587, .114));
    //fc = fc*.5 + pow(min(vec3(1.5, 1, 1)*gr, 1.), vec3(1, 3, 16))*.5;
    
     // Approximate gamma correction.
	fragColor = vec4(pow(clamp(fc, 0., 1.), vec3(1./2.)), 1.0); // 1./2.2, etc.
    
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

